/*FUNCTION scheduling.resource_timeline__abk_ab2__termination__grouped(

Teilt ABK so auf, das in der ABK zusammenhängende Gruppiert werden und zusammenhängend terminiert werden. Prüft dazu die Abfolge der AGs ob an einem AG Gruppen hängen und unterbricht dann entsprechend und terminiert erst die Gruppe und dann weiter
https://ci.prodat-sql.de/sources/tests/suite/9/runner/1112

*/
SELECT tsystem.function__drop_by_regex( 'resource_timeline__abk_ab2__termination__grouped', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.resource_timeline__abk_ab2__termination__grouped(
      -- ACHTUNG IN Params-Block IDENTISCH resource_timeline__abk_ab2__termination_internal
      IN _abk_ix                         integer,
      
      IN _timeframe_start                timestamp,
      IN _timeframe_end                  timestamp,
      
      IN _write_to_disk                  bool = false,
      
      IN _direction                      varchar = 'forward',       -- Erlaubt sind "forward" (Vorwärtsterminuerung) und "backward" (Rückwärtsterminierung).
      
      IN _scenario                       varchar = null,            -- TODO AXS: Unbenutzt! Kann das weg?
      
      IN _checkBlockedTimes              bool = true,               -- Bei 'false' DLZ-Terminierung: Ignoriert Blockierungen auf der Ressource durch andere Task*-Einträge. Es werden nur Off-Times beachtet.
      
      IN _blocktime_refcursor            refcursor = null,

      IN _termination_start_time         timestamp = null,          -- > Mittelpunktterminierung. Ansonsten identisch mit Anfang/Ende
      IN _termination_start_ab2_id       int = null,                -- > Mittelpunktterminierung ab AG. Bei normaler Terminierung auch ab AG durch äußere Funktion, dann identisch mit Start/Ende AG bzw null 
  
      IN _termination_range_ab2_id_start int = null,                -- > Von AG
      IN _termination_range_ab2_id_end   int = null,                -- > Bis AG

      IN _allow_overlap                  bool = false,              -- Überlappungen bei der Terminierung von Arbeitsgängen innerhalb der gleichen ABK erlauben.
      IN _resource_id_main_fix__set      bool = false,              -- Erzwinge das Fixieren der in der Terminierung gewählten Arbeitsplatzressourcen. Wird sonst nur bei _write_to_disk = true gemacht.
      IN _loglevel                       int DEFAULT TSystem.Log_Get_LogLevel( _user => 'yes' )
      ) 
      RETURNS TABLE  
        (
        -- TODO TYPE!  => FUNCTION scheduling.resource_timeline__abk_group__termination dort auch anzupassen bei Änderungen!
        __ab2_id                  integer,
        __resource_id             integer,
        __slotStartDate           timestamp,
        __slotEndDate             timestamp,
        __type                    scheduling.resource_timeline_blocktype,
        __slotFactor              numeric(16,6),
        __usage                   numeric(12,8),
        __stat                    text,
        __debughint               text
        ) 
      AS $$

      DECLARE
    
          _r record;
          _ra record;
          _r_termination_internal record;
    
          -- Anfang und Ende AG der initialen ABK
          _ab2_a2_n_range           int[];
    
          -- zu terminierende ab2-s
          _ab2s_to_terminate        int[];
    
          _timeframe_start_adjusted timestamp;      -- Angepasster Beginn des vorgegebenen Zeitfensters
          _timeframe_end_adjusted   timestamp;      -- Angepasstes Ende des vorgegebenen Zeitfensters
    
          _last_slot_min timestamp;
          _last_slot_max timestamp;
    
          _direction_order_mult integer;
          _forward bool;
          _block_resource_id integer;
    
          _range_ab2_id_start integer;
          _range_ab2_id_end integer;
    
          _total_ab2_id_start integer;              -- Mittelpunktterminierung: hält die AG, welche in die erste Richtung tatsächlich terminiert wurden (beachtet Verkettungen)
          _total_ab2_id_end integer;                -- wie zuvor
    
          _total_slot_dat_min timestamp;            -- Mittelpunktterminierung: hält das in die erste Richtung errechnete Zeitfenster
          _total_slot_dat_max timestamp;            -- wie zuvor
    
          _was_group bool;                          -- vorheriger Datensatz war Gruppe/Verkettung
          _is_group bool = null;                    -- Wir sind in einer Gruppe.
    
          _prefix  varchar := format( 'resource_timeline__abk_ab2__termination__grouped abk_ix:%L -', _abk_ix );
    
          _time_grid        CONSTANT integer := TSystem.Settings__GetInteger( 'scheduling.time_grid', 60 ); -- Zeitraster
          _ab2_in_group_cnt integer;                                                                        -- Anzahl der AGs in Gruppe
          _group_buffer     interval;                                                                       -- Puffer der Gruppe (Zeit, die der zusammenhängende Timeslot über alle AGs künstlich in beide Richtungen verlängert wird)
    
      BEGIN
    
          IF _direction = 'forward' THEN
            _direction_order_mult := 1;
            _forward              := true;
    
            -- Bereich, der für die Terminierung ausgewählten Arbeitsgangnummern ermitteln.
            _ab2_a2_n_range := scheduling.abk__ab2__range_number__get( _abk_ix, coalesce(_termination_start_ab2_id, _termination_range_ab2_id_start), _termination_range_ab2_id_end, _validate_range => false );
          ELSE
            _direction_order_mult := -1;
            _forward              := false;
    
            _ab2_a2_n_range := scheduling.abk__ab2__range_number__get( _abk_ix, _termination_range_ab2_id_start, coalesce(_termination_start_ab2_id, _termination_range_ab2_id_end), _validate_range => false );        
          END IF;
    
          -- Mittelpunktterminierung: wir splitten hier nach vorn und hinten auf, damit verkettete AGs zusammenhängend bearbeitet werden.
          -- Das Select gibt uns auch AGs zurück, welche durch die Verkettung hineingezogen werden, obwohl sie außerhalb der Grenzen der Mittelpunktterminierung liegen.
          -- im 2. Schritt rufen wir dann hier den Rest auf der ABK in die andere Richtung (ohne nochmaligen Mittelpunkt) bearbeitet und zuvor evtl vorhandene Verkettungen sind somit berücksichtigt
        
    
          RAISE NOTICE '%', format(
              $call$
                        call: scheduling.resource_timeline__abk_ab2__termination__grouped(
                              _abk_ix => %L,
                              _timeframe_start => %L,
                              _timeframe_end => %L,
                              _write_to_disk => %L,
                              _direction => %L,
                              _scenario => %L,
                              _checkBlockedTimes => %L,
                              _blocktime_refcursor => %L,
                              _termination_start_time => %L,
                              _termination_start_ab2_id => %L,
                              _termination_range_ab2_id_start => %L,
                              _termination_range_ab2_id_end => %L,
                              _allow_overlap => %L,
                              _resource_id_main_fix__set => %L,
                              _loglevel => %L
                        )
    
                        _ab2_a2_n_range[1]=%L, _ab2_a2_n_range[2]=%L
                        timestamp=%L
              $call$,
              _abk_ix, _timeframe_start, _timeframe_end, _write_to_disk,
              _direction, _scenario, _checkBlockedTimes,
              _blocktime_refcursor,
              _termination_start_time, _termination_start_ab2_id,
              _termination_range_ab2_id_start, _termination_range_ab2_id_end, _allow_overlap, _resource_id_main_fix__set,
              _loglevel,
              _ab2_a2_n_range[1], _ab2_a2_n_range[2],
              clock_timestamp()::time
          );
    
          -- nichts zu terminieren: zB nur nicht planrelevante Resourcen oder alles bereits beendet etc!
          IF _ab2_a2_n_range[1] IS null AND _ab2_a2_n_range[2] IS null THEN
            RAISE NOTICE 'resource_timeline__abk_ab2__termination__grouped EXIT > abk__ab2__range_number__get IS null: ab_ix = %, ab2_id_start = %, ab2_id_end = %', _abk_ix, _termination_range_ab2_id_start, _termination_range_ab2_id_end;
            RETURN;
          END IF;


          --- !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
          --- !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
          --  KEIN RETURN IM CODE OHNE ENABLE!!!
          PERFORM disablebedarfberech();
          --- !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

    
          -- Start ID reingegben, welche ein nicht planrelevanter AG ist (zB Info AG 10)
          IF _ab2_a2_n_range[1] IS null AND _termination_range_ab2_id_start IS NOT null THEN
              _ab2_a2_n_range[1] := (tabk.ab2__next__get(a2_id, true, true)).a2_n FROM ab2 WHERE a2_id = _termination_range_ab2_id_start;
              RAISE NOTICE 'adjust _ab2_a2_n_range[1] to: %', _ab2_a2_n_range[1];
          END IF;
          IF _ab2_a2_n_range[2] IS null AND _termination_range_ab2_id_end IS NOT null THEN
            _ab2_a2_n_range[2] := (tabk.ab2__prior__get(a2_id, true, true)).a2_n FROM ab2 WHERE a2_id = _termination_range_ab2_id_end;
            RAISE NOTICE 'adjust _ab2_a2_n_range[2] to: %', _ab2_a2_n_range[2];
          END IF;
    
    
          _timeframe_start_adjusted := coalesce(_termination_start_time, _timeframe_start); -- _termination_start_time => Mittelpunktterminierung! gibt Grenze vor ab der terminiert werden darf!
          _timeframe_end_adjusted   := _timeframe_end;

          IF _termination_start_time IS NOT null AND _direction = 'backward' THEN
              RAISE EXCEPTION 'NOT YET IMPLEMENTED/TESTED (middle backward)';
          END IF;

         -- Im ermittelten Bereich nun partitionieren nach "Existenz von Gruppierung"
         -- Alle Arbeitsgänge holen und dazu die ab2_groups anhängig
         -- Siehe: https://ci.prodat-sql.de/sources/tests/suite/9/runner/1112#teststep-17134
         -- TODO AXS: Durchläuft Teile bereits durchlaufene Gruppen mehrfach. Dann "WARNING:  a2_n x of abk y are already terminated!" Mehrfachdurchläufe einer Gruppe verhindern!
         FOR _r IN
            WITH
              -- für CI! https://ci.prodat-sql.de/sources/tests/suite/9/runner/1112#teststep-17789
              --_vars AS (SELECT -1 AS _direction_order_mult, 'backward'::varchar AS _direction, false AS _forward),
              --_vars AS (SELECT  1 AS _direction_order_mult,  'forward'::varchar AS _direction, true  AS _forward),
              GroupedData AS (
                  SELECT  a2_id,
                          a2_n,
                          a2_ab_ix,
                          ab2_groups__array,
    
                          CASE WHEN _forward THEN
    
                                    lag(ab2_groups__array) OVER (PARTITION BY a2_ab_ix ORDER BY a2_n)
                               ELSE                          
                                    lead(ab2_groups__array) OVER (PARTITION BY a2_ab_ix ORDER BY a2_n DESC) -- ORDER BY DESC. MANDATORY Wieso auch immer. Verschiebt das Ergebnis in den Zeilen nach oben.
    
    
                          END AS ab2_groups__array__by_direction,                      
    
                            row_number() OVER (PARTITION BY a2_ab_ix ORDER BY a2_n)
                          - row_number() OVER (PARTITION BY a2_ab_ix, ab2_groups__array ORDER BY a2_n) -- KEIN _direction_order_mult. Wieso auch immer
    
                          AS group_change,
                          
                          -- Die kette des folgenden AG enthält uns mit, das heißt wir haben den schon enthalten und er ist in unserer Kette
                          CASE WHEN _forward THEN
    
                                    lag(ab2_groups__array) OVER (PARTITION BY a2_ab_ix ORDER BY a2_n)  @> ab2_groups__array
                               ELSE                          
                                    ab2_groups__array <@ lead(ab2_groups__array) OVER (PARTITION BY a2_ab_ix ORDER BY a2_n) -- KEIN ORDER BY DESC. Wieso auch immer
    
                          END AS samegroup
    
                    FROM ab2
                    LEFT JOIN ab2_wkstplan ON a2w_a2_id = a2_id AND NOT a2w_marked = -1 -- SplitAGs;
                    JOIN ksv ON ks_abt = coalesce(a2w_resource_ks_abt_main_fix, a2_ks)
                         --, _vars
                    CROSS JOIN LATERAL (SELECT array_agg( a2_id_chain ORDER BY pos) AS ab2_groups__array
                                          FROM tabk.ab2_groups__recursive__by__a2_id__by__direction__get(a2_id, _direction)
                                          JOIN ab2 ON a2_id = a2_id_chain
                                         WHERE NOT a2_ende
                                        ) AS groups
                    -- im ci auskommentieren! > für CI! https://ci.prodat-sql.de/sources/tests/suite/9/runner/1112#teststep-17789
                    WHERE a2_ab_ix = _abk_ix
                      AND NOT a2_ende
                      AND ks_plan
                      AND a2_n BETWEEN _ab2_a2_n_range[1] AND _ab2_a2_n_range[2]
                    ORDER BY a2_n * _direction_order_mult
              )
              -- SELECT * FROM GroupedData
              ,Unfiltered AS (
                  SELECT min(a2_n)  AS min_a2_n,
                         -- min(a2_id) AS min_a2_id,
                         max(a2_n)  AS max_a2_n,
                         -- max(a2_id) AS max_a2_id,
                         
                         array_agg(a2_id ORDER BY a2_n * _direction_order_mult) AS ab2_array, -- ORDER BY ? ab_ix ? -- wenn AG keine Follower, ist er mit seinen direkten Nachfolgern zusammengezogen
                         
                         a2_ab_ix,
                         ab2_groups__array,
                         samegroup,
                         
                         ab2_groups__array__by_direction                                        
                    FROM GroupedData
                         --, _vars
                    WHERE samegroup IS NOT true
                      -- a2_ende einbauen
                    GROUP BY a2_ab_ix, ab2_groups__array, ab2_groups__array__by_direction, group_change, samegroup 
              )
              SELECT a2_ab_ix,
                     min_a2_n, max_a2_n,
                     ab2_array,
                     ab2_groups__array,
                     samegroup
                     --,*
                FROM Unfiltered
                     --, _vars
               --WHERE samegroup IS NOT true
               ORDER BY a2_ab_ix * _direction_order_mult, IFTHEN(_forward, min_a2_n, max_a2_n * _direction_order_mult)
            LOOP           
                _was_group := _is_group; -- vorheriger DS war eine Verkettung!
                _is_group := _r.ab2_groups__array IS NOT null; -- Wir sind in einer Gruppe.
        
                -- Datensatzwechsel ist IMMER bei Welchsel von Verkettung zu normal, oder zurück. Dann bringen wir immer einen Puffer ein, auch da keine Transportzeit berücksichtigt!
                
                IF _loglevel >= 4 THEN
                  RAISE NOTICE '_was_group <> _is_group: %-%, %, %, %, %, %', _was_group, _is_group, _r.a2_ab_ix, _r.min_a2_n, _r.max_a2_n, _r.ab2_groups__array, _r.samegroup;
                END IF;
    
                -- TODO hier nicht statisch 4 Stunden, sondern "scheduling.resource__transport_time_defaults__get" einfache variante anhand a2_ids
                IF _was_group <> _is_group THEN              
                  IF _forward THEN
                    _timeframe_start_adjusted := _timeframe_start_adjusted + interval '4 hours';
                  ELSE
                    _timeframe_end_adjusted := _timeframe_end_adjusted - interval '4 hours';
                  END IF;
                END IF;
    
                IF _loglevel >= 4 THEN
                  RAISE NOTICE 'resource_timeline__abk_ab2__termination (before): _timeframe_start=%, _timeframe_end=%, _timeframe_start_adjusted=%, _timeframe_end_adjusted=%', _timeframe_start, _timeframe_end, _timeframe_start_adjusted, _timeframe_end_adjusted;   
                END IF;
    
                -- Wenn Gruppe, dann Gruppe terminieren und Datumsbereich eingrenzen. Sonst normal terminieren!
                IF _is_group THEN
    
                    _ab2_in_group_cnt   := array_length( _r.ab2_groups__array, 1 );
                    _group_buffer       := 0; --coalesce( _ab2_in_group_cnt, 1 ) * _time_grid * interval '1 second';
    
                    -- Debug
                    IF _loglevel >= 4 THEN
                        RAISE NOTICE 'elements:%, elements cnt:%, buffer:%, _timeframe_start_adjusted=%, _timeframe_end_adjusted=%', _r.ab2_groups__array, _ab2_in_group_cnt, _group_buffer, _timeframe_start_adjusted, _timeframe_end_adjusted;
                    END IF;
    
                    -- alle gruppierten AGs zusammenhängend terminieren!
                    -- Zusammenhängenden Timeslot über alle AGs finden!
                    -- NOTE AXS: Hier zusätzlichen Puffer addieren, um den zusammenhängenden Timeslot über alle AGs zu vergrößern bzw. aufrunden, damit alle zusammenhängenden AGs auch bei Rundungseffekten reinpassen.
                    -- Der zusammenhängende Timeslot über alle AGs wird erst nach der Ermittlung der zu belegenden Lücke vergrößert. Dadurch passen die AGs der Gruppe auch dann rein, wenn direkt an den Grenzen der Gruppe andere AGs schon einterminiert sind (z.B. bei "Vorwärts und Packen").
                    -- Ggf. kommt es dann zu leichten Überlappungen an den Grenzen der Gruppe.
                    -- siehe Kommentar unten "Damit wäre ggfs auch die Thematik der Puffer irrelevant"
                    SELECT resource_id, 
                           ( slot_start - IFTHEN(_forward, interval '0 minutes', interval '15 minutes') /*_group_buffer*/ ),
                           ( slot_end + IFTHEN(_forward, interval '15 minutes', interval '0 minutes') /* _group_buffer */)
                      INTO _block_resource_id,
                           _timeframe_start_adjusted, 
                           _timeframe_end_adjusted
                      FROM scheduling.abk__termination_ab2s__as__block__by__a2_ids(_r.ab2_groups__array, 
                                                                                   _direction, 
                                                                                   IFTHEN(_forward, _timeframe_start_adjusted, _timeframe_end_adjusted), 
                                                                                   _checkBlockedTimes, 
                                                                                   _allow_overlap, 
                                                                                   _loglevel => _loglevel
                                                                                   );
    
                    IF _loglevel >= 4 THEN  
                      RAISE NOTICE 'termination__grouped: ab2_groups__array=%, resource_id_main_fix=%, direction=%, startdate=%, _timeframe_start_adjusted=%, _timeframe_end_adjusted=%', _r.ab2_groups__array, _block_resource_id, _direction, IFTHEN(_forward, _timeframe_start, _timeframe_end), _timeframe_start_adjusted, _timeframe_end_adjusted;
                    END IF;
    
                    IF _timeframe_start_adjusted IS null THEN
                      RAISE EXCEPTION 'abk__termination_ab2s__as__block__by__a2_ids: Kein Terminierungsergebnis im vorgegeben Zeitfenster gefunden für Gruppenterminierung, a2_ids: %, %, %', _r.ab2_groups__array, _direction, _timeframe_start;
                    END IF;
    
    
                    --resource_fix
                    PERFORM scheduling.ab2_wkstplan__resource_id_main_fix__move__set(a2_ids, _block_resource_id, false, _loglevel => _loglevel) FROM unnest(_r.ab2_groups__array) AS a2_ids; --ACHTUNG setzt doppelt und dreifach

                ELSIF _was_group THEN
                    -- IsGroup => False, WasGroup => True. Wir verlassen die Gruppe, dann muss die Grenze auch wieder zurückgesetzt werden, auf den Ausgangspunkt, da ja derzeit BlockTermination das TimeFrame Adjustet eingeschränkt hatte
                    -- prinzipiell könnte man auch überlegen, das in die jeweilige Richtung ans Ende gar nicht erst zu verändern, da ja final nur der Statpunkt relevant ist. Damit wäre ggfs auch die Thematik der Puffer irrelevant
                    IF _forward THEN
                        _timeframe_end_adjusted := _timeframe_end;
                    ELSE
                        _timeframe_start_adjusted := _timeframe_start;
                    END IF;

                END IF;
    
                FOR _ra IN (-- alle aufeinanderfolgenden AGs innerhalb dieser ABK als ein Datensatz. resource_timeline__abk_ab2__termination bekommt diese einfach als ersten und letzten AG zu terminieren und terminiert diese somit "normal"
                           SELECT 0 AS pos,
                                  a2_ab_ix,
                                  min(a2_n)  AS a2_n_min,  max(a2_n)  AS a2_n_max,
                                  min(a2_id) AS a2_id_min, max(a2_id) AS a2_id_max
                             FROM unnest(_r.ab2_array)
                             JOIN ab2 ON a2_id = unnest
                               -- ausschliessen das ich selbst Follower (Gruppen) habe, dann bin ich selbst im nächsten UNION mit enthalten!
                            WHERE _r.ab2_groups__array IS null
                            GROUP BY a2_ab_ix
                            UNION
                           -- Gruppierte AGs. Immer der AG aus der ABK selbst UND seine Follower als Einzeldatensätz*e*!!!!!! in Reihenfolge der Anlage der Gruppierung!
                           SELECT array_position(_r.ab2_groups__array, a2_id) + 1000 AS pos,
                                  a2_ab_ix,
                                  a2_n, a2_n,
                                  a2_id, a2_id
                             FROM unnest(_r.ab2_groups__array)
                             JOIN ab2 ON a2_id = unnest
                               -- wenn ich keine Gruppierung bin, wäre ich im ersten Array enthalten!
                            WHERE _r.ab2_groups__array IS NOT null
                           ORDER BY pos
                          )
                LOOP
    
    
                    IF _ra.pos > 0 THEN
                          -- AG Verkettung
                          _range_ab2_id_start := _ra.a2_id_min;
                          _range_ab2_id_end := _ra.a2_id_min; -- min = max da jeder AG für sich einzeln
                    ELSIF -- Range von AGs
                       _direction = 'forward' THEN
                          -- aufeinanderfolgende AGs in ABK
                          _range_ab2_id_start := _r.ab2_array[1];
                          _range_ab2_id_end := _r.ab2_array[array_length(_r.ab2_array, 1)];
                    ELSE
                        _range_ab2_id_start := _r.ab2_array[array_length(_r.ab2_array, 1)];
                        _range_ab2_id_end := _r.ab2_array[1];
                    END IF;
    
                    -- Bei Mittelpunktterminierung merken wir uns Startpunkt und schieben den Endepunkt immer weiter pro Block
                    IF _direction = 'forward' THEN
                        IF _total_ab2_id_start IS null THEN
                          _total_ab2_id_start := _range_ab2_id_start;
                        END IF;
                        _total_ab2_id_end := _range_ab2_id_end;
                    ELSE
                        IF _total_ab2_id_end IS null THEN
                          _total_ab2_id_end := _range_ab2_id_end;
                        END IF;
                        _total_ab2_id_start := _range_ab2_id_start;
                    END IF;
    
                    IF _loglevel >= 4 THEN
                      RAISE NOTICE 'pos=%, ab_ix=%, a2_n_min=%, a2_id_min=%, a2_n_max=%, a2_id_max=% _timeframe_start_adjusted=%, _timeframe_end_adjusted=%', _ra.pos, _ra.a2_ab_ix, _ra.a2_n_min, _range_ab2_id_start, _ra.a2_n_max, _range_ab2_id_end, _timeframe_start_adjusted, _timeframe_end_adjusted;
                    END IF;
    
                    -- Eigentliches Terminierien!
                    FOR _r_termination_internal IN
    
                       SELECT --/*
                              resource_timeline__abk_ab2__termination.*,
                              --*/
                              /*
                              null AS __ab2_id,
                              null AS __resource_id,
                              null AS __slotStartDate,
                              null AS __slotEndDate,
                              null AS __type,
                              null AS __slotFactor,
                              null AS __usage,
                              --*/ -- Debug Ende für auskommentieren Funktion
                              _ra.pos,
                              _ra.a2_ab_ix,
                              _ra.a2_n_min,
                              _ra.a2_n_max
                         FROM scheduling.resource_timeline__abk_ab2__termination(
                                   _abk_ix => _ra.a2_ab_ix
                                   -- ACHTUNG: daran denken, das hier immer ich als AG UND meine Gruppe in einem Select bin (ODER->einfacherer Fall ohne Gruppe, dann eine Menge aufeinanderfolgender!)
                                   -- timeframe_adjusted ist somit immer für meine Folgegruppe ermittelt!
                                   ,_timeframe_start => _timeframe_start_adjusted
                                   ,_timeframe_end   => _timeframe_end_adjusted
                                   ,_write_to_disk => _write_to_disk
                                   ,_direction => _direction
                                   ,_scenario => _scenario
                                   ,_checkBlockedTimes => _checkBlockedTimes
                                   ,_blocktime_refcursor => _blocktime_refcursor
                                   ,_termination_start_time => null -- _termination_start_time -- ?? Weg da Mittelpunkt direkt in Grenzen mitgeben!?
                                   ,_termination_start_ab2_id => null -- Mittelpunktterminierung wurde hier vorab aufgelöst in obere und untere Hälfte!  // _termination_start_ab2_id
                                   ,_termination_range_ab2_id_start => _range_ab2_id_start
                                   ,_termination_range_ab2_id_end   => _range_ab2_id_end
                                   ,_allow_overlap =>    ( _allow_overlap OR _is_group )           -- Falls in Gruppe, Überlappung erlauben. Zur Zeit Probleme mit Transportzeit, wenn wir in Gruppe sind.
                                                      OR ( _termination_start_ab2_id IS NOT null ) -- Mittelpunkt erlaubt überlappung, damit im Anschluss korrekt in die andere Richtung nachgerückt wird.
                                   ,_resource_id_main_fix__set => _resource_id_main_fix__set
                                   ,_loglevel => _loglevel
                               )
                         LEFT JOIN ab2 ON a2_id = resource_timeline__abk_ab2__termination.__ab2_id
                         LEFT JOIN LATERAL scheduling.resource__translate__resource_id__to__ksvba__shorthand(resource_timeline__abk_ab2__termination.__resource_id) AS ksvba ON true
                         LEFT JOIN LATERAL scheduling.ksv__is_top_ksv__by__ks_abt(ksb_ks_abt) ON true
                        WHERE ksv__is_top_ksv__by__ks_abt IS false                          
                    LOOP
    
                       __ab2_id         := _r_termination_internal.__ab2_id;
                       __resource_id    := _r_termination_internal.__resource_id;
                       __slotStartDate  := _r_termination_internal.__slotStartDate;
                       __slotEndDate    := _r_termination_internal.__slotEndDate;
                       __type           := _r_termination_internal.__type;
                       __slotFactor     := _r_termination_internal.__slotFactor;
                       __usage          := _r_termination_internal.__usage;
    
                       -- Für FolgeAGs in der Terminierung setzen wir nun den Startpunkt innerhalb der ABK. NICHT auf das Ende der Gruppe. Sonst würde der folgende AG der ABK erst nach Ende der Gruppe zu spät beginnen. Überlappung gewünscht
                       -- IF _r_termination_internal.a2_ab_ix = _abk_ix THEN
                         _last_slot_min := greatest(_last_slot_min, _r_termination_internal.__slotEndDate); -- bei Vorwärtsterminieren verschiebt sich das mögliche Zeitfenster nach vorn, auf das Ende vom vorherigen!
                         _last_slot_max := least(_last_slot_max, _r_termination_internal.__slotStartDate);  -- bei Rückwärtsterminieren verkleinert sich es auf den Anfang des letzten!
    
                         _total_slot_dat_min := least(_total_slot_dat_min, _r_termination_internal.__slotStartDate); -- Für Mittelpunktterminierung merken!
                         _total_slot_dat_max := greatest(_total_slot_dat_max, _r_termination_internal.__slotEndDate);
                       -- END IF;
    
                       RETURN NEXT;
                    END LOOP;
    
                    IF _direction = 'forward' THEN
                      _timeframe_start_adjusted := _last_slot_min; -- während Loop & gruppenterminierung, auch weitergeben!
                    ELSE
                      _timeframe_end_adjusted   := _last_slot_max; -- während Loop & gruppenterminierung, auch weitergeben!
                    END IF;
    
                    IF _loglevel >= 4 THEN
                      RAISE NOTICE 'resource_timeline__abk_ab2__termination (after): _timeframe_start_adjusted=%, _timeframe_end_adjusted=%', _timeframe_start_adjusted, _timeframe_end_adjusted;                
                    END IF;
    
                 END LOOP;
    
            END LOOP;
         -- FOR
    
         
         PERFORM enablebedarfberech();
         PERFORM do_artikel_bedarf();
    

         -- Mittelpunktterminierung => ruft uns selbst wieder rekursiv auf!
         -- Mittelpunktterminierung
         -- Mittelpunktterminierung: nun die andere Richtung. Im Unterschied zu Folgebeibedarf werden diese IMMER herangezogen. Unabhängig davon könnte/müßte man die Algorithmen hier zusammenfassen. TODO!!!!!
         IF _termination_start_ab2_id IS NOT null THEN
           
           --IF _loglevel >= 3 THEN
              RAISE NOTICE 'Mittelpunktterminierung:\n             middle => _total_ab2_id_start=% _total_slot_dat_min:% _total_ab2_id_end=% _total_slot_dat_max:%,  _termination_range_ab2_id_start=%, _termination_range_ab2_id_end=%',  _total_ab2_id_start, _total_slot_dat_min, _total_ab2_id_end, _total_slot_dat_max, _termination_range_ab2_id_start, _termination_range_ab2_id_end;
           --END IF;
    
           IF _direction  = 'forward' THEN
              -- wir hatten vorwärts
              _direction := 'backward';
              
              _termination_range_ab2_id_end   :=  (tabk.ab2__prior__get(_total_ab2_id_start, true, true)).a2_id;

              IF _termination_range_ab2_id_end IS null THEN
                RETURN; -- es gibt keinen rückwärtigen Vorgänger!
              END IF;

              -- resource__transport_time__get wirft selbst debug notice
              _timeframe_end := scheduling.resource__transport_time_defaults__get(_total_slot_dat_min, 
                                                                                  _ab2_from,
                                                                                  _ab2_to,
                                                                                  -1::integer
                                                                                  )
                                  FROM ab2 _ab2_from,
                                       ab2 _ab2_to
                                 WHERE _ab2_from.a2_id = _total_ab2_id_start
                                   AND _ab2_to.a2_id   = _termination_range_ab2_id_end;

              RAISE NOTICE 'middle.resource__transport_time__get => _timeframe_end = %', _timeframe_end;

              -- _timeframe_start: kommt von außen direkt mit bei Mittelpunktterminierung und ist idR heute. Es gibt Untere Grenze, Mittelpunkt ab dem terminiert wird und obere Grenze
              IF _termination_range_ab2_id_start IS NOT null /*AND NOT _allow_overlap*/ THEN -- wir haben eine Grenze nach vorn. Diese muss eingehalten werden.
                  SELECT a2_et INTO _r FROM ab2 WHERE a2_id = (tabk.ab2__prior__get(_termination_range_ab2_id_start, true, true)).a2_id;

                  RAISE WARNING 'middle.limit start NOT YET TESTED/IMPLEMENTED => _termination_range_ab2_id_start = %; _timeframe_start = % to a2_et = % + 4 hours', _termination_range_ab2_id_start, _timeframe_start, _r.a2_et; 

                  IF _r.a2_et IS NOT null THEN
                    -- _timeframe_start := _r.a2_et + interval '4 hours';
                  END IF;
                  -- theoretisch nochmal transportzeit defaults
              END IF;              

           ELSE 
              RAISE EXCEPTION 'NOT YET TESTED (middle backward)';
              -- wir hatten rückwärts
              _direction := 'forward';
    
              _termination_range_ab2_id_start :=  (tabk.ab2__next__get(_total_ab2_id_end, true, true)).a2_id;

              IF _termination_range_ab2_id_start IS null THEN
                RETURN; -- es gibt keinen Nachfolger!
              END IF;              

              -- resource__transport_time__get wirft selbst debug notice
              _timeframe_start := scheduling.resource__transport_time_defaults__get(_total_slot_dat_min, 
                                                                                    _ab2_from,
                                                                                    _ab2_to,
                                                                                    1::integer
                                                                                    )
                                    FROM ab2 _ab2_from,
                                         ab2 _ab2_to
                                   WHERE _ab2_from.a2_id = _total_ab2_id_end
                                     AND _ab2_to.a2_id   = _termination_range_ab2_id_start;

              RAISE NOTICE 'middle.resource__transport_time__get => _timeframe_start = %', _timeframe_start; 

              -- _timeframe_end    => siehe Kommentar bei "-- _timeframe_start:" vor ELSE
              IF _termination_range_ab2_id_end IS NOT null /*AND NOT _allow_overlap*/ THEN -- wir haben eine Grenze nach vorn. Diese muss eingehalten werden.
                  SELECT a2_at INTO _r FROM ab2 WHERE a2_id = (tabk.ab2__next__get(_termination_range_ab2_id_end, true, true)).a2_id;

                  RAISE WARNING 'middle.limit stop NOT YET TESTED/IMPLEMENTED => _termination_range_ab2_id_end = %; _timeframe_start = % to a2_at = % - 4 hours', _termination_range_ab2_id_end, _timeframe_start, _r.a2_at; 

                  IF _r.a2_at IS NOT null THEN
                    _timeframe_end := _r.a2_at - interval '4 hours';
                  END IF;
                  -- theoretisch nochmal transportzeit defaults
              END IF;                                     

           END IF;

           __stat := null;
           _checkBlockedTimes := true; -- erster Durchlauf Mittelpunkt Rückwärts mit Berücksichtigung Auslastung
           
           -- wenn wir am Anfang oder Ende der ABK stehen, gibt Next/Prio NULL zurück. Dann gibt es keine Mittelpunktterminierung! Eine Grenze muss gesetzt sein
           IF _termination_range_ab2_id_start IS NOT null OR _termination_range_ab2_id_end IS NOT null THEN
           <<_following_ab2__middle__backward__dlz>>
           LOOP               

              BEGIN

               FOR _r_termination_internal IN
                   SELECT * FROM scheduling.resource_timeline__abk_ab2__termination__grouped( _abk_ix                           => _abk_ix
                                                                                             ,_timeframe_start                  => _timeframe_start
                                                                                             ,_timeframe_end                    => _timeframe_end
                                                                                             ,_write_to_disk                    => _write_to_disk
                                                                                             ,_direction                        => _direction
                                                                                             ,_scenario                         => _scenario
                                                                                             ,_checkBlockedTimes                => _checkBlockedTimes -- _following_ab2__middle__backward__dlz => erster Versuch mit Berücksichtigung Kapazität ranziehen. 2. Versuch DLZ
                                                                                             ,_blocktime_refcursor              => _blocktime_refcursor
                                                                                             ,_termination_start_time           => null -- _termination_start_time -- nicht mehr notwendig, da wir uns nur noch in eine Richtung bewegen!
                                                                                             ,_termination_start_ab2_id         => null -- _termination_start_ab2_id => wir sind bereits in die ander Richtung unterwegs!
                                                                                             ,_termination_range_ab2_id_start   => _termination_range_ab2_id_start
                                                                                             ,_termination_range_ab2_id_end     => _termination_range_ab2_id_end
                                                                                             ,_allow_overlap                    => _allow_overlap -- Folge bei Bedarf (was mit OR hier übergeben wurde) kann bei Mittelpunktterminierung im nächsten Schritt noch AGs nach hinten schieben. Daher TRUE (AGs können noch vor uns liegen, die dann noch nach hinten geschoben werden)
                                                                                             ,_resource_id_main_fix__set        => _resource_id_main_fix__set
                                                                                             ,_loglevel                         => _loglevel
                                                                                           )
               LOOP                   
        
                   __ab2_id         := _r_termination_internal.__ab2_id;
                   __resource_id    := _r_termination_internal.__resource_id;
                   __slotStartDate  := _r_termination_internal.__slotStartDate;
                   __slotEndDate    := _r_termination_internal.__slotEndDate;
                   __type           := _r_termination_internal.__type;
                   __slotFactor     := _r_termination_internal.__slotFactor;
                   __usage          := _r_termination_internal.__usage;
                   __stat           := '_following_ab2__middle';
                   __debughint      := '_checkBlockedTimes=' || _checkBlockedTimes::varchar;

                   -- RAISE NOTICE 'middle => %, %, %', __ab2_id, __debughint, __stat;
        
                   RETURN NEXT;
        
               END LOOP;

              EXCEPTION
                WHEN others THEN
                     -- Fehler abfangen. Unten wird dann nochmal vorwärts terminiert.
                    IF __stat IS null THEN
                        RAISE WARNING '_following_ab2__middle__backward__dlz => %', SQLERRM;
                    ELSE
                        RAISE EXCEPTION '_following_ab2__middle__backward__dlz__failed => %', SQLERRM;
                    END IF;
              END; 
    
               -- wäre das Mittelpunkt rückwärts mit Kapazaitätsberücksichtigung erfolgreich, hatte _stat einen Wert hier! Somit nochmal nochmal DLZ
               IF __stat IS null THEN
                 __stat := '_following_ab2__middle';
                 _checkBlockedTimes := false;
                 _timeframe_start := _timeframe_start::date - 90; -- bei DLZ bewußt etwas in die Vergangenheit zulassen?! Wegen Auswärts!
                 RAISE WARNING 'middle => failed, now DLZ';
                 CONTINUE _following_ab2__middle__backward__dlz;
               END IF;

               EXIT; -- LOOP LABEL

           END LOOP; 
           END IF;

         END IF; -- IF _termination_start_ab2_id IS NOT null THEN
    
         RETURN;
    
        END $$ LANGUAGE plpgsql;
    --